<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section2
#  Version : R2.0.8.S04                                   
#  Intermediate release number : 039-20210209                             
#  Last update : 06/07/2020                                                      
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<!--RULE TitleOfContract-->
	<xsl:template match="*[@FORM!='1' and @FORM!='11']//*[starts-with(local-name(),'OBJECT')] | *[starts-with(local-name(),'OBJECT_SUPPLY')] | OBJECT_WORKS_PRIOR_INFORMATION | OBJECT_CONTRACT_NOTICE_DESCRIPTION" mode="R134">
		<xsl:choose>
			<xsl:when test="descendant::*[self::TITLE_CONTRACT or 
                self::TITLE_QUALIFICATION_SYSTEM or 
                self::TITLE_NOTICE_BUYER_PROFILE or 
                self::TITLE_DESIGN_CONTACT_NOTICE or 
                self::TITLE_RESULT_DESIGN_CONTEST][descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='7']">TITLE_QUALIFICATION_SYSTEM</xsl:when>
						<xsl:when test="//*[@FORM='8']">TITLE_NOTICE_BUYER_PROFILE</xsl:when>
						<xsl:when test="//*[@FORM='12']">TITLE_DESIGN_CONTACT_NOTICE</xsl:when>
						<xsl:when test="//*[@FORM='13']">TITLE_RESULT_DESIGN_CONTEST</xsl:when>
						<xsl:otherwise>TITLE_CONTRACT</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R134'"/>
					<xsl:with-param name="content" select="concat($ele, ' missing')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R134"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R134"/>
	<xsl:template match="@*|node()" priority="-2" mode="R134">
		<xsl:apply-templates select="@*|*" mode="R134"/>
	</xsl:template>
	<!--RULE shortContractDescription-->
	<xsl:template match="*[@FORM='1'or @FORM='16']//TOTAL_QUANTITY_OR_SCOPE[not(ancestor::LOT_PRIOR_INFORMATION)] | 
        SHORT_CONTRACT_DESCRIPTION | 
        DESCRIPTION_OF_CONTRACT | 
        SHORT_DESCRIPTION |
        *[@FORM='7'or @FORM='13']//DESCRIPTION |
        SHORT_DESCRIPTION_CONTRACT" mode="R135">
		<xsl:choose>
			<xsl:when test="descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='1' or @FORM='16']">TOTAL_QUANTITY_OR_SCOPE</xsl:when>
						<xsl:when test="//*[@FORM='2' or @FORM='3' or @FORM='5' or @FORM='15' or @FORM='17' or @FORM='18' or @FORM='T01' or @FORM='T02']">SHORT_CONTRACT_DESCRIPTION</xsl:when>
						<xsl:when test="//*[@FORM='4' or @FORM='10']">DESCRIPTION_OF_CONTRACT</xsl:when>
						<xsl:when test="//*[@FORM='6']">SHORT_DESCRIPTION</xsl:when>
						<xsl:when test="//*[@FORM='7' or @FORM='13']">DESCRIPTION</xsl:when>
						<xsl:otherwise>SHORT_DESCRIPTION_CONTRACT</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R135'"/>
					<xsl:with-param name="content" select="concat($ele, ' missing')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R135"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R135"/>
	<xsl:template match="@*|node()" priority="-2" mode="R135">
		<xsl:apply-templates select="@*|*" mode="R135"/>
	</xsl:template>
	<!--RULE TypeAndNatureContract-->
	<!-- F2,3,5,6,15,17,18,19,4app-->
	<xsl:template match="*[@FORM!='16' and @FORM!='8' and @FORM!='9']//TYPE_CONTRACT" priority="1006" mode="R137">
		<xsl:choose>
			<xsl:when test="following-sibling::*[child::* or attribute::* or matches(local-name(),'SERVICE')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="//*[@FORM='4']">(ANNEX_I) </xsl:if>The type (<xsl:value-of select="./@VALUE"/>) and the nature (unknown!)</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137"/>
	</xsl:template>
	<!--F4app, contract type optional!-->
	<xsl:template match="ANNEX_I" priority="1005" mode="R137">
		<xsl:choose>
			<xsl:when test=".//TYPE_CONTRACT"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'"/>
					<xsl:with-param name="content" select="'(ANNEX_I) The type (unknown!) and the nature (unknown!)'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137"/>
	</xsl:template>
	<!--F4-->
	<xsl:template match="*[@FORM='4']//*[@CONTRACT_TYPE='SERVICES']" priority="1004" mode="R137">
		<xsl:choose>
			<xsl:when test=".[@SERVICES_CATEGORY]"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'"/>
					<xsl:with-param name="content" select="'The type (SERVICES) and the nature (service category unknown!)'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137"/>
	</xsl:template>
	<!--F16-->
	<xsl:template match="TYPE_CONTRACT[@VALUE='SERVICES']" priority="1003" mode="R137">
		<xsl:choose>
			<xsl:when test="following-sibling::SERVICE_CATEGORY_DEFENCE"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'"/>
					<xsl:with-param name="content" select="'The type (SERVICES) and the nature (service category unknown!)'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137"/>
	</xsl:template>
	<!-- F10-->
	<xsl:template match="*[@FORM='10']" priority="1002" mode="R137">
		<xsl:choose>
			<xsl:when test=".//F10_CONTRACT_TYPE/*"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'"/>
					<xsl:with-param name="content" select="'The nature (unknown!)'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137"/>
	</xsl:template>
	<!--F11 -->
	<xsl:template match="*[@FORM='11']" priority="1001" mode="R137">
		<xsl:choose>
			<xsl:when test=".//F11_CONTRACT_TYPE/*"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'"/>
					<xsl:with-param name="content" select="'The nature (unknown!)'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137"/>
	</xsl:template>
	<!--F7 -->
	<xsl:template match="OBJECT_QUALIFICATION_SYSTEM" priority="1000" mode="R137">
		<xsl:choose>
			<xsl:when test=".//F07_CONTRACT_TYPE[@VALUE='WORKS' or @VALUE='SUPPLIES']"/>
			<xsl:when test=".//F07_CONTRACT_TYPE[@VALUE='SERVICES'] and .//SERVICE_CATEGORY"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R137'"/>
					<xsl:with-param name="content" select="''"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R137"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R137"/>
	<xsl:template match="@*|node()" priority="-2" mode="R137">
		<xsl:apply-templates select="@*|*" mode="R137"/>
	</xsl:template>
	<!--RULE service category F15-->
	<xsl:template match="*[@FORM='15']" mode="R138">
		<xsl:choose>
			<xsl:when test=".//@NOTICE='CONTRACTING_DEFENCE' and not(.//SERVICE_CATEGORY)"/>
			<xsl:when test=".//@NOTICE!='CONTRACTING_DEFENCE' and not(.//SERVICE_CATEGORY_DEFENCE)"/>
			<xsl:otherwise>
				<xsl:variable name="ele">NOTICE_PUBLISHED/@NOTICE='<xsl:value-of select=".//@NOTICE"/>' and <xsl:value-of select="local-name(.//TYPE_CONTRACT/following-sibling::*)"/>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R138'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R138"/>
	<xsl:template match="@*|node()" priority="-2" mode="R138">
		<xsl:apply-templates select="@*|*" mode="R138"/>
	</xsl:template>
	<!--PATTERN OneAndOnlyContractType-->
	<xsl:template match="*[@FORM]" mode="R139">
		<xsl:choose>
			<xsl:when test="not(
                (
                (
                .//node()[string(@*[1])='SERVICES']|
                .//attribute::SERVICES_CATEGORY|
                .//SERVICE_CATEGORY|.//SERVICE_CATEGORY_PUB|.//SERVICE_CATEGORY_PUB_DEFENCE|.//SERVICE_CATEGORY_DEFENCE                  
                ) 
                and                 
                (
                (.//node()[string(@*[1])='SUPPLIES']|.//SUPPLIES|.//TYPE_SUPPLIES_CONTRACT) 
                or 
                (.//node()[string(@*[1])='WORKS']|.//TYPE_WORK_CONTRACT|.//OBJECT_WORKS_PRIOR_INFORMATION)
                )
                )
                or 
                (
                (.//node()[string(@*[1])='SUPPLIES']|.//SUPPLIES|.//TYPE_SUPPLIES_CONTRACT) and
                (.//node()[string(@*[1])='WORKS']|.//TYPE_WORK_CONTRACT|.//OBJECT_WORKS_PRIOR_INFORMATION)
                )                
                ) "/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R139'"/>
					<xsl:with-param name="content" select="''"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R139"/>
	<xsl:template match="@*|node()" priority="-2" mode="R139">
		<xsl:apply-templates select="@*|*" mode="R139"/>
	</xsl:template>
	<!--PATTERN number of sections II-->
	<xsl:template match="*[@FORM='4'][.//@CONTRACT_TYPE='WORKS']" mode="R140">
		<xsl:choose>
			<xsl:when test="count(.//OBJECT_CONTRACT_PERIODIC_INDICATIVE)=1"/>
			<xsl:otherwise>
				<xsl:variable name="ele">WORKS and more than one OBJECT_CONTRACT_PERIODIC_INDICATIVE</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R140'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R140"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R140"/>
	<xsl:template match="@*|node()" priority="-2" mode="R140">
		<xsl:apply-templates select="@*|*" mode="R140"/>
	</xsl:template>
	<!--PATTERN duration of contract-->
	<xsl:template match="OBJECT_CONTRACT_PERIODIC_INDICATIVE" mode="R142">
		<xsl:choose>
			<xsl:when test=".//PERIOD_WORK_DATE_STARTING[not(ancestor::*[matches(local-name(),'LOT')])][DAYS|MONTHS|.//START_DATE]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">OBJECT_CONTRACT_PERIODIC_INDICATIVE/SCHEDULED_DATE_PERIOD/PERIOD_WORK_DATE_STARTING/* missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R142'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R142"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R142"/>
	<xsl:template match="@*|node()" priority="-2" mode="R142">
		<xsl:apply-templates select="@*|*" mode="R142"/>
	</xsl:template>
	<!--PATTERN number of sections IV-->
	<xsl:template match="*[@FORM='4'][.//@CONTRACT_TYPE='WORKS']" mode="R143">
		<xsl:choose>
			<xsl:when test="count(.//PROCEDURE_ADMINISTRATIVE_INFORMATION_PERIODIC)=1"/>
			<xsl:otherwise>
				<xsl:variable name="ele">WORKS and more than one PROCEDURE_ADMINISTRATIVE_INFORMATION_PERIODIC</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R143'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R143"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R143"/>
	<xsl:template match="@*|node()" priority="-2" mode="R143">
		<xsl:apply-templates select="@*|*" mode="R143"/>
	</xsl:template>
	<!--PATTERN estimated cost-->
	<xsl:template match="*[@FORM='4'][.//@CONTRACT_TYPE!='WORKS']" mode="R144">
		<xsl:if test=".//COMPLEMENTARY_INFORMATION_PERIODIC_INDICATIVE[
            not(descendant::VALUE_COST[number(translate(text(),', ','.'))>0])
            and 
            not(descendant::RANGE_VALUE_COST[number(translate(LOW_VALUE/text(),', ','.'))>0 and number(translate(HIGH_VALUE/text(),', ','.'))>number(translate(LOW_VALUE/text(),', ','.'))] )
            ]">
			<xsl:if test=".//OBJECT_CONTRACT_PERIODIC_INDICATIVE[ 
                not(descendant::ESTIMATED_COST_MAIN_FINANCING//VALUE_COST[number(translate(text(),', ','.'))>0]) 
                and
                not(descendant::ESTIMATED_COST_MAIN_FINANCING//RANGE_VALUE_COST[number(translate(LOW_VALUE/text(),', ','.'))>0 and number(translate(HIGH_VALUE/text(),', ','.'))>number(translate(LOW_VALUE/text(),', ','.'))])
                ]">
				<xsl:variable name="ele">
					<xsl:value-of select=".//@CONTRACT_TYPE"/> and (RANGE_)VALUE_COST missing/incorrect</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R144'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
		<xsl:apply-templates select="@*|*" mode="R144"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R144"/>
	<xsl:template match="@*|node()" priority="-2" mode="R144">
		<xsl:apply-templates select="@*|*" mode="R144"/>
	</xsl:template>
	<!--PATTERN nuts location-->
	<xsl:template match="*[@FORM='2' or @FORM='5' or @FORM='10' or @FORM='11']|*[@FORM='1'and descendant::*[starts-with(local-name(),'OBJECT_WORKS')]]" mode="R145">
		<xsl:choose>
			<xsl:when test="descendant::NUTS"/>
			<xsl:when test="(descendant::LABEL|descendant::LOCATION|descendant::MAIN_SITE_WORKS)[
                descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')
                ]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">{<xsl:choose>
						<xsl:when test="@FORM='10' or @FORM='11'">MAIN_SITE_WORKS</xsl:when>
						<xsl:when test="@FORM='2' or @FORM='5'">LOCATION</xsl:when>
						<xsl:otherwise>LABEL</xsl:otherwise>
					</xsl:choose>,NUTS} missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R145'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R145"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R145"/>
	<xsl:template match="@*|node()" priority="-2" mode="R145">
		<xsl:apply-templates select="@*|*" mode="R145"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='15'][.//CONTRACTS_DPS and .//@NOTICE='CONTRACTING_DEFENCE']" mode="R146">
		<xsl:variable name="ele">CONTRACTS_DPS and NOTICE_PUBLISHED/@NOTICE='CONTRACTING_DEFENCE'</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R146'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R146"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R146"/>
	<xsl:template match="@*|node()" priority="-2" mode="R146">
		<xsl:apply-templates select="@*|*" mode="R146"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='1']//*[matches(local-name(),'OBJECT_SUPPLY_SERVICE|OBJECT_WORKS')]|*[@FORM='5']" mode="R147">
		<xsl:choose>
			<xsl:when test="descendant::FRAMEWORK_AGREEMENT"/>
			<xsl:when test="descendant::NOTICE_INVOLVES/*"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//*[@FORM='5']">ESTABLISHMENT_FRAMEWORK_AGREEMENT,SETTING_UP_DPS,PUBLIC_CONTRACT missing</xsl:when>
						<xsl:otherwise>FRAMEWORK_AGREEMENT missing</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R147'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R147"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R147"/>
	<xsl:template match="@*|node()" priority="-2" mode="R147">
		<xsl:apply-templates select="@*|*" mode="R147"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="F04_FRAMEWORK|F05_FRAMEWORK" mode="R148">
		<xsl:choose>
			<xsl:when test="not(child::*)"/>
			<xsl:when test="preceding-sibling::*/ESTABLISHMENT_FRAMEWORK_AGREEMENT"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="//*[@FORM='4']">
						<xsl:text>(ANNEX_I)</xsl:text>
					</xsl:if>
					<xsl:value-of select="local-name(.)"/> without ESTABLISHMENT_FRAMEWORK_AGREEMENT</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R148'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R148"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R148"/>
	<xsl:template match="@*|node()" priority="-2" mode="R148">
		<xsl:apply-templates select="@*|*" mode="R148"/>
	</xsl:template>
	<!--PATTERN-->
	<xsl:template match="F02_FRAMEWORK[child::* and not(preceding-sibling::*/ESTABLISHMENT_FRAMEWORK_AGREEMENT)]" priority="1004" mode="R149">
		<xsl:variable name="ele">F02_FRAMEWORK without ESTABLISHMENT_FRAMEWORK_AGREEMENT</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R149'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R149"/>
	</xsl:template>
	<xsl:template match="*[@FORM='2'][.//ESTABLISHMENT_FRAMEWORK_AGREEMENT]" priority="1003" mode="R149">
		<xsl:choose>
			<xsl:when test=".//F02_FRAMEWORK[
                (SINGLE_OPERATOR|SEVERAL_OPERATORS) and
                (DURATION_FRAMEWORK_YEAR|DURATION_FRAMEWORK_MONTH)[number()&gt;0] and 
                (descendant::VALUE_COST|descendant::RANGE_VALUE_COST) and
                descendant::FREQUENCY_AWARDED_CONTRACTS[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')] 
                ]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">ESTABLISHMENT_FRAMEWORK_AGREEMENT and missing/incomplet F02_FRAMEWORK</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R149'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R149"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R149"/>
	<xsl:template match="@*|node()" priority="-2" mode="R149">
		<xsl:apply-templates select="@*|*" mode="R149"/>
	</xsl:template>
	<!--PATTERN review-->
	<xsl:template match="F02_FRAMEWORK[preceding::ESTABLISHMENT_FRAMEWORK_AGREEMENT and (child::DURATION_FRAMEWORK_YEAR[number()>4]|child::DURATION_FRAMEWORK_MONTH[number()>48])]" mode="R150">
		<xsl:choose>
			<xsl:when test="JUSTIFICATION[descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:value-of select="local-name(DURATION_FRAMEWORK_YEAR|DURATION_FRAMEWORK_MONTH)"/>=<xsl:value-of select="number(DURATION_FRAMEWORK_YEAR|DURATION_FRAMEWORK_MONTH)"/> and missing/empty JUSTIFICATION</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R150'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R150"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R150"/>
	<xsl:template match="@*|node()" priority="-2" mode="R150">
		<xsl:apply-templates select="@*|*" mode="R150"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='15'][.//@NOTICE='CONTRACTING_DEFENCE' and .//CONTRACT_COVERED_GPA]" mode="R151">
		<xsl:variable name="ele">CONTRACT_COVERED_GPA and NOTICE_PUBLISHED/@NOTICE='CONTRACTING_DEFENCE'</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R151'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R151"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R151"/>
	<xsl:template match="@*|node()" priority="-2" mode="R151">
		<xsl:apply-templates select="@*|*" mode="R151"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='1' and descendant::*[matches(local-name(),'OBJECT_WORKS')]]|*[(@FORM='2' or @FORM='5')][.//@VALUE='WORKS']" mode="R152">
		<xsl:choose>
			<xsl:when test=".//*[matches(local-name(),'DIV_INTO_LOT_YES|DIV_INTO_LOT_NO')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">WORKS and missing <xsl:choose>
						<xsl:when test="//*[@FORM='1']">F01_</xsl:when>
						<xsl:when test="//*[@FORM='2']">F02_</xsl:when>
						<xsl:otherwise>F05_</xsl:otherwise>
					</xsl:choose>DIV_INTO_LOT_YES/DIV_INTO_LOT_NO</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R152'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R152"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R152"/>
	<xsl:template match="@*|node()" priority="-2" mode="R152">
		<xsl:apply-templates select="@*|*" mode="R152"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2'][not(descendant::ACCEPTED_VARIANTS)]" mode="R153">
		<xsl:variable name="ele">missing ACCEPTED_VARIANTS</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R153'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R153"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R153"/>
	<xsl:template match="@*|node()" priority="-2" mode="R153">
		<xsl:apply-templates select="@*|*" mode="R153"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='1']//OBJECT_SUPPLY_SERVICE_PRIOR_INFORMATION[descendant::SERVICE_CATEGORY]" mode="R154">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(local-name(),'VALUE_COST') and not(ancestor::*[matches(local-name(),'LOT')])]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">SERVICE_CATEGORY and missing (RANGE_)VALUE_COST</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R154'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R154"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R154"/>
	<xsl:template match="@*|node()" priority="-2" mode="R154">
		<xsl:apply-templates select="@*|*" mode="R154"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='5' or @FORM='9' or @FORM='10' or @FORM='11']//*[matches(local-name(),'^OBJECT') and not(matches(local-name(),'DESCRIPTION$'))]" mode="R155">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(local-name(),'VALUE_COST') and not(ancestor::*[matches(local-name(),'LOT|FRAMEWORK')])]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(RANGE_)VALUE_COST missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R155'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R155"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R155"/>
	<xsl:template match="@*|node()" priority="-2" mode="R155">
		<xsl:apply-templates select="@*|*" mode="R155"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="ANNEX_I" mode="R156">
		<xsl:choose>
			<xsl:when test="descendant::TOTAL_QUANTITY_OR_SCOPE[
                not(ancestor::*[matches(local-name(),'LOT|FRAMEWORK')]) and 
                (descendant::P[matches(text()[1],'[\p{L}\p{N}]+')] or matches(text()[1],'[\p{L}\p{N}]+'))
                ] and 
                descendant::*[matches(local-name(),'VALUE_COST') and not(ancestor::*[matches(local-name(),'LOT|FRAMEWORK')])]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(ANNEX_I) {TOTAL_QUANTITY_OR_SCOPE,RANGE_)VALUE_COST} missing/incomplete </xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R156'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R156"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R156"/>
	<xsl:template match="@*|node()" priority="-2" mode="R156">
		<xsl:apply-templates select="@*|*" mode="R156"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='3' or @FORM='6' or @FORM='15']//*[matches(local-name(),'^OBJECT')]" mode="R157">
		<xsl:choose>
			<xsl:when test="descendant::*[matches(local-name(),'VALUE_COST')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(RANGE_)VALUE_COST missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R157'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R157"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R157"/>
	<xsl:template match="@*|node()" priority="-2" mode="R157">
		<xsl:apply-templates select="@*|*" mode="R157"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2'] | ANNEX_I" mode="R159">
		<xsl:choose>
			<xsl:when test="descendant::NO_OPTIONS"/>
			<xsl:when test="descendant::*[matches(local-name(),'PROVISIONAL_TIMETABLE') and number() &gt;0]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:if test="//*[@FORM='4']">(ANNEX_I) </xsl:if>{NO_OPTIONS, PROVISIONAL_TIMETABLE_MONTH or PROVISIONAL_TIMETABLE_DAY...} missing/incorrect</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R159'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R159"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R159"/>
	<xsl:template match="@*|node()" priority="-2" mode="R159">
		<xsl:apply-templates select="@*|*" mode="R159"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='5']" mode="R160">
		<xsl:choose>
			<xsl:when test="descendant::OPTIONS|descendant::NO_OPTIONS"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(NO_)OPTIONS missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R160'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R160"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R160"/>
	<xsl:template match="@*|node()" priority="-2" mode="R160">
		<xsl:apply-templates select="@*|*" mode="R160"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='5']" mode="R161">
		<xsl:choose>
			<xsl:when test="descendant::NO_RECURRENT_CONTRACT"/>
			<xsl:when test="descendant::*[matches(local-name(),'RENEWALS') and number() &gt;0]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">{NO_RECURRENT_CONTRACT,NUMBER_POSSIBLE_RENEWALS_...} missing/incorrect</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R161'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R161"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R161"/>
	<xsl:template match="@*|node()" priority="-2" mode="R161">
		<xsl:apply-templates select="@*|*" mode="R161"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="ANNEX_I" mode="R162">
		<xsl:choose>
			<xsl:when test="descendant::NO_RECURRENT_CONTRACT"/>
			<xsl:when test="descendant::*[matches(local-name(),'RENEWALS') and number()&gt;0] and descendant::*[matches(local-name(),'TIME_FRAME_SUBSEQUENT') and number() &gt;0]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">(ANNEX_I) {NO_RECURRENT_CONTRACT,NUMBER_POSSIBLE_RENEWALS...,TIME_FRAME_SUBSEQUENT_CONTRACTS_...} missing/incomplete</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R162'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R162"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R162"/>
	<xsl:template match="@*|node()" priority="-2" mode="R162">
		<xsl:apply-templates select="@*|*" mode="R162"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='2' or @FORM='5']" mode="R163">
		<xsl:choose>
			<xsl:when test="descendant::PERIOD_WORK_DATE_STARTING[not(ancestor::*[matches(local-name(),'LOT')])][(DAYS|MONTHS)[number()&gt;0] or (.//START_DATE and .//END_DATE)]"/>
			<xsl:otherwise>
				<xsl:variable name="ele">{DAYS,MONTHS,START_DATE,END_DATE} missing/incomplete</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R163'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R163"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R163"/>
	<xsl:template match="@*|node()" priority="-2" mode="R163">
		<xsl:apply-templates select="@*|*" mode="R163"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='1']//*[matches(local-name(),'OBJECT_SUPPLY_SERVICE')]" mode="R164">
		<xsl:choose>
			<xsl:when test="child::PROCEDURE_DATE_STARTING"/>
			<xsl:otherwise>
				<xsl:variable name="ele">PROCEDURE_DATE_STARTING missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R164'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R164"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R164"/>
	<xsl:template match="@*|node()" priority="-2" mode="R164">
		<xsl:apply-templates select="@*|*" mode="R164"/>
	</xsl:template>
	<!--PATTERN -->
	<xsl:template match="*[@FORM='1']//*[matches(local-name(),'OBJECT_SUPPLY_SERVICE|OBJECT_WORKS')]" mode="R165">
		<xsl:choose>
			<xsl:when test="child::CONTRACT_COVERED_GPA"/>
			<xsl:otherwise>
				<xsl:variable name="ele">CONTRACT_COVERED_GPA missing</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R165'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R165"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R165"/>
	<xsl:template match="@*|node()" priority="-2" mode="R165">
		<xsl:apply-templates select="@*|*" mode="R165"/>
	</xsl:template>
	<!--disabled-->
	<xsl:template match="*[./CPV and .//TYPE_CONTRACT]" mode="R388">
		<xsl:variable name="error_nb">
			<xsl:value-of select="
			count(.[.//TYPE_CONTRACT/@*='SUPPLIES']/CPV/CPV_MAIN/CPV_CODE[not(45>number(substring(@*,1,2)) or number(substring(@*,1,2))=48)])
			+ count(.[.//TYPE_CONTRACT/@*='WORKS']/CPV/CPV_MAIN/CPV_CODE[number(substring(@*,1,2))!=45])
			+ count(.[.//TYPE_CONTRACT/@*='SERVICES']/CPV/CPV_MAIN/CPV_CODE[49>number(substring(@*,1,2)) or number(substring(@*,1,2))>98])"/>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM='16' or @FORM='17' or @FORM='19']"/>
			<xsl:when test="$error_nb>0">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R388'"/>
					<xsl:with-param name="content" select="concat(./local-name(),'[',.//TYPE_CONTRACT/@*,', ',./CPV/CPV_MAIN/CPV_CODE/@*,']')"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R388"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R388"/>
	<xsl:template match="@*|node()" priority="-2" mode="R388">
		<xsl:apply-templates select="@*|*" mode="R388"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[./CPV and .//TYPE_CONTRACT]" mode="R390">
		<xsl:variable name="error_nb">
			<xsl:value-of select="
			count(.[.//TYPE_CONTRACT/@*='SUPPLIES']/CPV/CPV_MAIN/CPV_CODE[not(45>number(substring(@*,1,2)) or number(substring(@*,1,2))=48)])
			+ count(.[.//TYPE_CONTRACT/@*='WORKS']/CPV/CPV_MAIN/CPV_CODE[number(substring(@*,1,2))!=45])
			+ count(.[.//TYPE_CONTRACT/@*='SERVICES']/CPV/CPV_MAIN/CPV_CODE[49>number(substring(@*,1,2)) or number(substring(@*,1,2))>98])"/>
		</xsl:variable>
		<xsl:choose>
			<!--<xsl:when test="ancestor::*[@FORM='18']"/>-->
			<xsl:when test="$error_nb>0">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R390'"/>
					<xsl:with-param name="content" select="concat(./local-name(),'[',.//TYPE_CONTRACT/@*,', ',./CPV/CPV_MAIN/CPV_CODE/@*,']')"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R390"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R390"/>
	<xsl:template match="@*|node()" priority="-2" mode="R390">
		<xsl:apply-templates select="@*|*" mode="R390"/>
	</xsl:template>
</xsl:stylesheet>
