<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section0   
#  Version : R2.0.8.S04                                  
#  Intermediate release number : 032-20191010                                 
#  Last update : 25/09/2019                                                     
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<xsl:template match="*" mode="R100">
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R100'"/>
			<xsl:with-param name="content" select="''"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R100"/>
	<xsl:template match="@*|node()" priority="-2" mode="R100">
		<xsl:apply-templates mode="R100"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R101">
		<xsl:if test="//*[@CURRENCY != //*/@CURRENCY[1]]">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R101'"/>
				<xsl:with-param name="content" select="''"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R101"/>
	<xsl:template match="@*|node()" priority="-2" mode="R101">
		<xsl:apply-templates mode="R101"/>
	</xsl:template>
	<!---->
	<xsl:template match="USER_E_MAILS" mode="R102">
		<xsl:variable name="ele">
			<xsl:if test="./*[not(@TYPE)]">'<xsl:value-of select="normalize-space(./*[not(@TYPE)][1])"/>'</xsl:if> TECHNICAL:'<xsl:value-of select="normalize-space(./*[@TYPE='TECHNICAL'][1])"/>' CONTENT:'<xsl:value-of select="normalize-space(./*[@TYPE='CONTENT'][1])"/>' COORDINATION:'<xsl:value-of select="normalize-space(./*[@TYPE='COORDINATION'][1])"/>' FUNCTIONAL:'<xsl:value-of select="normalize-space(./*[@TYPE='FUNCTIONAL'][1])"/>' RESPONSIBLE:'<xsl:value-of select="normalize-space(./*[@TYPE='RESPONSIBLE'][1])"/>'</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R102'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
		<xsl:apply-templates select="@*|*" mode="R102"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R102"/>
	<xsl:template match="@*|node()" priority="-2" mode="R102">
		<xsl:apply-templates select="@*|*" mode="R102"/>
	</xsl:template>
	<!---->
	<xsl:template match="URL|URL_BUYER|URL_DOCUMENT|URL_GENERAL|URL_DPS|URL_INFORMATION|URL_PARTICIPATE" mode="R103">
		<xsl:if test="(string-length(normalize-space(.))&gt; 250) or 	matches(normalize-space(./text()),'(\w\s\w)|((w|W){3}(.*)?){2,}|((http|HTTP|https|HTTPS)(.*)?){2,}|((w|W){3}(.*)?(http|HTTP|https|HTTPS))|([;,.\\]$)') or not(matches(normalize-space(./text()),'((^(http|HTTP|https|HTTPS|ftp|FTP|ftps|FTPS|sftp|SFTP)://)|(^(w|W){3}(\d)?\.))[\w\?!\./:;,\-_=#+*%@&quot;\(\)&amp;]+'))">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R103'"/>
				<xsl:with-param name="content" select="concat(local-name(.),' with value ', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R103"/>
	<xsl:template match="@*|node()" priority="-2" mode="R103">
		<xsl:apply-templates select="@*|*" mode="R103"/>
	</xsl:template>
	<!---->
	<xsl:template match="USER_E_MAIL|E_MAIL" mode="R105">
		<xsl:if test="(string-length(normalize-space(.))&gt; 250  ) or not(matches(normalize-space(.),'^[A-Za-z0-9!#$%&amp;''*+/=?_-]+(\.[A-Za-z0-9!#$%&amp;''*+/=?_-]+)*@([A-Za-z0-9]([A-Za-z0-9_-]*[A-Za-z0-9])?\.)+([A-Za-z]{2,})$'))">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R105'"/>
				<xsl:with-param name="content" select="concat(local-name(.),' with value ', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R105"/>
	<xsl:template match="@*|node()" priority="-2" mode="R105">
		<xsl:apply-templates select="@*|*" mode="R105"/>
	</xsl:template>
	<!---->
	<xsl:template match="NOTICE_NUMBER_OJ" mode="R107">
		<xsl:choose>
			<xsl:when test="matches(./text(),'^(20|19)\d{2}/S (((00)?[1-9])|([0]?[1-9][0-9])|(1[0-9][0-9])|(2[0-5][0-9]))-\d{6}$')"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R107'"/>
					<xsl:with-param name="content" select="concat(local-name(.),' with value ',&quot;'&quot;,current(),&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R107"/>
	<xsl:template match="@*|node()" priority="-2" mode="R107">
		<xsl:apply-templates select="@*|*" mode="R107"/>
	</xsl:template>
	<!---->
	<xsl:template match="LOGIN[CUSTOMER_LOGIN or @CLASS]" mode="R108">
		<xsl:choose>
			<xsl:when test="./ESENDER_LOGIN/text()='ENOTICES' or ./ESENDER_LOGIN/text()='SIMAP2'"/>
			<xsl:when test="@CLASS='D' and matches( normalize-space(./CUSTOMER_LOGIN/text()) ,'[A-Za-z0-9]+')"/>
			<xsl:when test="@CLASS!='D' and string-length(normalize-space(./CUSTOMER_LOGIN))=0"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R108'"/>
					<xsl:with-param name="content" select="concat( local-name(.), '[@CLASS=', &quot;'&quot;,string(./@CLASS),&quot;'&quot;,']' , ', CUSTOMER_LOGIN=', &quot;'&quot;, normalize-space(./CUSTOMER_LOGIN), &quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R108"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R108"/>
	<xsl:template match="@*|node()" priority="-2" mode="R108">
		<xsl:apply-templates select="@*|*" mode="R108"/>
	</xsl:template>
	<!---->
	<xsl:template match="LOGIN[not(@CLASS) and not(ancestor::ADMINISTRATIVE_INFORMATION)]" mode="R111">
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R111'"/>
			<xsl:with-param name="content" select="concat('LOGIN[@CLASS=', &quot;'&quot;&quot;'&quot;,']')"/>
		</xsl:call-template>
		<xsl:apply-templates mode="R111"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R111"/>
	<xsl:template match="@*|node()" priority="-2" mode="R111">
		<xsl:apply-templates select="@*|*" mode="R111"/>
	</xsl:template>
	<!---->
	<xsl:template match="SENDER[.//@CLASS='D' or .//@CLASS='C']" mode="R112">
		<xsl:choose>
			<xsl:when test=".//@TYPE='CONTENT' and .//@TYPE='TECHNICAL'"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R112'"/>
					<xsl:with-param name="content" select="''"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R112"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R112"/>
	<xsl:template match="@*|node()" priority="-2" mode="R112">
		<xsl:apply-templates select="@*|*" mode="R112"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R114">
		<xsl:choose>
			<xsl:when test=".//OFFICIALNAME[not (matches( text() ,'[\p{L}\p{N}]+'))]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R114'"/>
					<xsl:with-param name="content" select="concat('OFFICIALNAME empty (total:',count (.//OFFICIALNAME[not (matches( normalize-space(text()) ,'[\p{L}\p{N}]+')) ]), ')')"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R114"/>
	<xsl:template match="@*|node()" priority="-2" mode="R114">
		<xsl:apply-templates select="@*|*" mode="R114"/>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R115">
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R115'"/>
			<xsl:with-param name="content" select="concat('Total CPV: ',count(.//*[matches(local-name(),'CPV')][attribute::CODE]/@CODE),' / Unique CPV: ',count(distinct-values(.//*[matches(local-name(),'CPV')][attribute::CODE]/@CODE)))"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R115"/>
	<xsl:template match="@*|node()" priority="-2" mode="R115">
		<xsl:apply-templates select="@*|*" mode="R115"/>
	</xsl:template>
	<!---->
	<xsl:template match="F01_DIV_INTO_LOT_YES|F02_DIV_INTO_LOT_YES|F05_DIV_INTO_LOT_YES|F16_DIV_INTO_LOT_YES|F17_DIV_INTO_LOT_YES|*[@FORM='4'][.//ANNEX_B_INFORMATION_LOTS_PERIODIC_INDICATIVE]" mode="R116">
		<xsl:choose>
			<xsl:when test="@FORM='4'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R116'"/>
					<xsl:with-param name="content" select="concat('Number of ANNEX_B: ',count(.//ANNEX_B_INFORMATION_LOTS_PERIODIC_INDICATIVE))"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R116'"/>
					<xsl:with-param name="content" select="concat(local-name(.),' and number of LOT: ',count(child::*))"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="@*|*" mode="R116"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R116"/>
	<xsl:template match="@*|node()" priority="-2" mode="R116">
		<xsl:apply-templates select="@*|*" mode="R116"/>
	</xsl:template>
	<!---->
	<xsl:template match="VALUE_COST|RANGE_VALUE_COST" mode="R158">
		<xsl:choose>
			<xsl:when test="self::VALUE_COST and not(number()>0)">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R158'"/>
					<xsl:with-param name="content" select="concat(local-name(),' with value ',&quot;'&quot;,string(),&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="self::RANGE_VALUE_COST and not(number(LOW_VALUE)>0 and number(HIGH_VALUE)>=number(LOW_VALUE))">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R158'"/>
					<xsl:with-param name="content" select="concat(local-name(),'[HIGH_VALUE=',string(HIGH_VALUE),', LOW_VALUE=',string(LOW_VALUE),']')"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
		<xsl:apply-templates mode="R158"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R158"/>
	<xsl:template match="@*|node()" priority="-2" mode="R158">
		<xsl:apply-templates select="@*|*" mode="R158"/>
	</xsl:template>
	<!---->
	<xsl:template match="NOTICE_DISPATCH_DATE" mode="R251">
		<xsl:choose>
			<xsl:when test="number(substring-before(//SENDER/NO_DOC_EXT/text(),'-'))=number(YEAR/text())"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R251'"/>
					<xsl:with-param name="content" select="concat('NO_DOC_EXT=',&quot;'&quot;,//SENDER/NO_DOC_EXT/text(),&quot;'&quot;,', NOTICE_DISPATCH_DATE/YEAR=',&quot;'&quot;,YEAR/text(),&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R251"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R251"/>
	<xsl:template match="@*|node()" priority="-2" mode="R251">
		<xsl:apply-templates select="@*|*" mode="R251"/>
	</xsl:template>
	<!---->
	<xsl:template match="YEAR" mode="R109">
		<xsl:choose>
			<xsl:when test="matches(./text(),'^(20|19)\d{2}$')"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R109'"/>
					<xsl:with-param name="content" select="concat(local-name(parent::*),'/', local-name(.),'= ',&quot;'&quot;,current(),&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R109"/>
	<xsl:template match="@*|node()" priority="-2" mode="R109">
		<xsl:apply-templates select="@*|*" mode="R109"/>
	</xsl:template>
	<!---->
	<xsl:template match="TOWN" mode="R110">
		<xsl:choose>
			<xsl:when test="matches(./text(),'^[^\n\r]*[^\W\d][^\n\r]*$')"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R110'"/>
					<xsl:with-param name="content" select="concat(local-name(.),'= ',&quot;'&quot;,current(),&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R110"/>
	<xsl:template match="@*|node()" priority="-2" mode="R110">
		<xsl:apply-templates select="@*|*" mode="R110"/>
	</xsl:template>
	<!---->
	<!-- Only forms T01,T02, F01-13,F15 are concerned by the R979 rule-->
	<xsl:template match="NOTICE_DISPATCH_DATE[number(YEAR/text())&lt;2019]" mode="R979">
		<xsl:choose>
			<xsl:when test="//*[@FORM='14' or @FORM='16' or @FORM='17' or @FORM='18' or @FORM='19']"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//@FORM='T01' or //@FORM='T02'">
							<xsl:value-of select="//@FORM"/>
						</xsl:when>
						<xsl:when test="//@FORM/number()&lt;10">
							<xsl:value-of select="concat('F0',//@FORM)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('F',//@FORM)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R979'"/>
					<xsl:with-param name="content" select="concat('Form/XSD [',$ele,'/R2.0.8.S04]')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R979"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R979"/>
	<xsl:template match="@*|node()" priority="-2" mode="R979">
		<xsl:apply-templates select="@*|*" mode="R979"/>
	</xsl:template>
	<!---->
	<!-- Only forms T01,T02, F01-13,F15 are concerned by the R980 rule-->
	<xsl:template match="NOTICE_DISPATCH_DATE[number(YEAR/text())&gt;2018]" mode="R980">
		<xsl:choose>
			<xsl:when test="//@FORM='14' or //@FORM='16' or //@FORM='17' or //@FORM='18' or //@FORM='19'"/>
			<xsl:otherwise>
				<xsl:variable name="ele">
					<xsl:choose>
						<xsl:when test="//@FORM='T01' or //@FORM='T02'">
							<xsl:value-of select="//@FORM"/>
						</xsl:when>
						<xsl:when test="//@FORM/number()&lt;10">
							<xsl:value-of select="concat('F0',//@FORM)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat('F',//@FORM)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R980'"/>
					<xsl:with-param name="content" select="concat('Form/XSD [',$ele,'/R2.0.8.S04]')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R980"/>
	</xsl:template>
	<xsl:template match="text()" priority="-1" mode="R980"/>
	<xsl:template match="@*|node()" priority="-2" mode="R980">
		<xsl:apply-templates select="@*|*" mode="R980"/>
	</xsl:template>
</xsl:stylesheet>
